/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.graphics.shader;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import java.io.IOException;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceProvider;
import xaero.common.MinimapLogs;
import xaero.common.graphics.shader.FramebufferLinesShader;
import xaero.common.graphics.shader.PositionTexAlphaTestShader;

public class MinimapShaders {
    public static FramebufferLinesShader FRAMEBUFFER_LINES = null;
    public static ShaderInstance POSITION_COLOR_TEX = null;
    public static ShaderInstance POSITION_COLOR_TEX_PRE = null;
    public static ShaderInstance POSITION_COLOR = null;
    public static ShaderInstance POSITION_TEX_NO_ALPHA_TEST = null;
    public static ShaderInstance POSITION_TEX_NO_ALPHA_TEST_NO_BLEND = null;
    public static PositionTexAlphaTestShader POSITION_TEX_ALPHA_TEST = null;
    public static PositionTexAlphaTestShader POSITION_TEX_ALPHA_TEST_NO_BLEND = null;
    public static PositionTexAlphaTestShader POSITION_TEX_ICON_OUTLINE = null;
    private static boolean firstTime = true;

    public static void onResourceReload(ResourceManager resourceManager) {
        String errorMessage = "Couldn't reload the minimap shaders!";
        try {
            FRAMEBUFFER_LINES = MinimapShaders.reloadShader(FRAMEBUFFER_LINES, new FramebufferLinesShader((ResourceProvider)resourceManager));
            POSITION_COLOR_TEX = MinimapShaders.reloadShader(POSITION_COLOR_TEX, new ShaderInstance((ResourceProvider)resourceManager, "xaerominimap/position_color_tex", DefaultVertexFormat.f_85818_));
            POSITION_COLOR_TEX_PRE = MinimapShaders.reloadShader(POSITION_COLOR_TEX_PRE, new ShaderInstance((ResourceProvider)resourceManager, "xaerominimap/position_color_tex_pre", DefaultVertexFormat.f_85818_));
            POSITION_COLOR = MinimapShaders.reloadShader(POSITION_COLOR, new ShaderInstance((ResourceProvider)resourceManager, "xaerominimap/position_color", DefaultVertexFormat.f_85818_));
            POSITION_TEX_NO_ALPHA_TEST = MinimapShaders.reloadShader(POSITION_TEX_NO_ALPHA_TEST, new ShaderInstance((ResourceProvider)resourceManager, "xaerominimap/pos_tex_no_alpha_test", DefaultVertexFormat.f_85817_));
            POSITION_TEX_NO_ALPHA_TEST_NO_BLEND = MinimapShaders.reloadShader(POSITION_TEX_NO_ALPHA_TEST_NO_BLEND, new ShaderInstance((ResourceProvider)resourceManager, "xaerominimap/pos_tex_no_alpha_test_no_blend", DefaultVertexFormat.f_85817_));
            POSITION_TEX_ALPHA_TEST = MinimapShaders.reloadShader(POSITION_TEX_ALPHA_TEST, new PositionTexAlphaTestShader((ResourceProvider)resourceManager, "xaerominimap/pos_tex_alpha_test"));
            POSITION_TEX_ALPHA_TEST_NO_BLEND = MinimapShaders.reloadShader(POSITION_TEX_ALPHA_TEST_NO_BLEND, new PositionTexAlphaTestShader((ResourceProvider)resourceManager, "xaerominimap/pos_tex_alpha_test_no_blend"));
            POSITION_TEX_ICON_OUTLINE = MinimapShaders.reloadShader(POSITION_TEX_ICON_OUTLINE, new PositionTexAlphaTestShader((ResourceProvider)resourceManager, "xaerominimap/pos_tex_icon_outline"));
            MinimapLogs.LOGGER.info("Successfully reloaded the minimap shaders!");
        }
        catch (IOException e) {
            if (firstTime) {
                throw new RuntimeException("Couldn't reload the minimap shaders!", e);
            }
            MinimapLogs.LOGGER.error("Couldn't reload the minimap shaders!", (Throwable)e);
        }
        firstTime = false;
    }

    private static <S extends ShaderInstance> S reloadShader(S current, S newOne) throws IOException {
        if (current != null) {
            current.close();
        }
        return newOne;
    }
}

